package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DocumentoOS2DaoImpl;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Ab0494s00DaoImpl generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoOS2CustomDaoImpl extends DocumentoOS2DaoImpl
		implements DocumentoOS2CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_094 IDDOCUMENTO094, t1.ID_TRAMITE_OS2_094 IDTRAMITEOS2094, t1.ORIGEN_094 ORIGEN094, t1.FECHA_DOC_094 FECHADOC094, t1.RUTA_PIF_094 RUTAPIF094, t1.NOMBRE_DOC_094 NOMBREDOC094, t1.OID_DOKUSI_094 OIDDOKUSI094, t1.ID_TIPO_DOC_094 IDTIPODOC094, t1.FORMATO_APORT_094 FORMATOAPORT094, t1.ID_TAREA_CONT_094 IDTAREACONT094, t1.ID_DATOS_ENVIO_POSTAL_094 IDDATOSENVIOPOSTAL094, t1.DESCRIPCION_ES_091 DESCRIPCIONES091, t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, t1.APORT_GEN_091 APORTGEN091 FROM VDOCUMENTO_OS2_TIPO t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS2> rwMap = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS2 documento = new DocumentoOS2(
					resultSet.getLong("IDDOCUMENTO094"),
					resultSet.getInt("ORIGEN094"),
					resultSet.getDate("FECHADOC094"),
					resultSet.getString("RUTAPIF094"),
					resultSet.getString("NOMBREDOC094"),
					resultSet.getString("OIDDOKUSI094"), null, null,
					resultSet.getString("FORMATOAPORT094"), null,
					new TramiteOS2(resultSet.getLong("IDTRAMITEOS2094")));

			documento.setTipoDocumento(
					new TipoDocumento(resultSet.getLong("IDTIPODOC094"),
							resultSet.getString("DESCRIPCIONES091"),
							resultSet.getString("DESCRIPCIONEU091"),
							resultSet.getString("TIPODOKUSI091"),
							resultSet.getString("ASUNTODOKUSI091"),
							resultSet.getString("APORTGEN091")));

			Long idTareaContinuar = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDTAREACONT094");
			if (idTareaContinuar != null) {
				documento.setTareaOS2Continuar(new TareaOS2(idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDDATOSENVIOPOSTAL094");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(
						new DatosEnvioPostal(idDatosEnvioPostal));
			}

			return documento;
		}
	};

	/**
	 * Finds a single row in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  Ab0494s00
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the documento OS 2
	 */
	@Transactional(readOnly = true)
	public DocumentoOS2 vfind(DocumentoOS2 ab0494s00) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_094 = ? ");

		List<DocumentoOS2> ab0494s00List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, ab0494s00.getIdDocumento094());
		return (DocumentoOS2) DataAccessUtils.uniqueResult(ab0494s00List);
	}

	/**
	 * Finds a list of rows in the Ab0494s00 table.
	 * 
	 *  ab0494s00
	 *            Ab0494s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0494s00>
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> vfindAll(DocumentoOS2 ab0494s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS2CustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0494s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0494s00 entity
	 * 
	 *  ab0494s00
	 *            Ab0494s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0494s00 the ab 0494 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS2 ab0494s00) {

		StringBuilder where = new StringBuilder(
				DocumentoOS2CustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0494s00 != null && ab0494s00.getIdDocumento094() != null) {
			where.append(" AND t1.ID_DOCUMENTO_094 = ?");
			params.add(ab0494s00.getIdDocumento094());
		}
		if (ab0494s00 != null && ab0494s00.getTramiteOS2() != null
				&& ab0494s00.getTramiteOS2().getIdTramite092() != null) {
			where.append(" AND t1.ID_TRAMITE_OS2_094 = ?");
			params.add(ab0494s00.getTramiteOS2().getIdTramite092());
		}
		if (ab0494s00 != null && ab0494s00.getOrigen094() != null) {
			where.append(" AND t1.ORIGEN_094 = ?");
			params.add(ab0494s00.getOrigen094());
		}
		if (ab0494s00 != null && ab0494s00.getFechaDoc094() != null) {
			where.append(" AND t1.FECHA_DOC_094 = ?");
			params.add(ab0494s00.getFechaDoc094());
		}
		if (ab0494s00 != null && ab0494s00.getRutaPif094() != null) {
			where.append(" AND t1.RUTA_PIF_094 = ?");
			params.add(ab0494s00.getRutaPif094());
		}
		if (ab0494s00 != null && ab0494s00.getNombreDoc094() != null) {
			where.append(" AND t1.NOMBRE_DOC_094 = ?");
			params.add(ab0494s00.getNombreDoc094());
		}
		if (ab0494s00 != null && ab0494s00.getOidDokusi094() != null) {
			where.append(" AND t1.OID_DOKUSI_094 = ?");
			params.add(ab0494s00.getOidDokusi094());
		}

		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_094 = ?");
			params.add(ab0494s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getDescripcionEs091() != null) {
			where.append(" AND t1.DESCRIPCION_ES_091 = ?");
			params.add(ab0494s00.getTipoDocumento().getDescripcionEs091());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getDescripcionEu091() != null) {
			where.append(" AND t1.DESCRIPCION_EU_091 = ?");
			params.add(ab0494s00.getTipoDocumento().getDescripcionEu091());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getTipoDokusi091() != null) {
			where.append(" AND t1.TIPO_DOKUSI_091 = ?");
			params.add(ab0494s00.getTipoDocumento().getTipoDokusi091());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getAsuntoDokusi091() != null) {
			where.append(" AND t1.ASUNTO_DOKUSI_091 = ?");
			params.add(ab0494s00.getTipoDocumento().getAsuntoDokusi091());
		}
		if (ab0494s00 != null && ab0494s00.getTipoDocumento() != null
				&& ab0494s00.getTipoDocumento().getAportGen091() != null) {
			where.append(" AND t1.APORT_GEN_091 = ?");
			params.add(ab0494s00.getTipoDocumento().getAportGen091());
		}
		if (ab0494s00 != null && ab0494s00.getFormatoAport094() != null) {
			where.append(" AND t1.FORMATO_APORT_094 = ?");
			params.add(ab0494s00.getFormatoAport094());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
